/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.item;

import com.github.mnesikos.simplycats.client.gui.CatBookScreen;
import com.github.mnesikos.simplycats.entity.SimplyCatEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CatBookItem
extends Item {
    public CatBookItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public void addBookmarkedPage(int id) {
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (target instanceof SimplyCatEntity && player.m_20163_()) {
            ListTag tagList;
            SimplyCatEntity cat = (SimplyCatEntity)target;
            stack = player.m_21120_(hand);
            CompoundTag compound = stack.m_41784_();
            boolean catExists = false;
            int catInList = 0;
            if (compound.m_128441_("pages")) {
                tagList = compound.m_128437_("pages", 10);
                for (int i = 0; i < tagList.size(); ++i) {
                    if (!tagList.m_128728_(i).m_128342_("UUID").equals(cat.m_20148_())) continue;
                    catExists = true;
                    catInList = i;
                    break;
                }
            } else {
                tagList = new ListTag();
                compound.m_128365_("pages", (Tag)tagList);
            }
            CompoundTag catTag = new CompoundTag();
            cat.m_20223_(catTag);
            ResourceLocation key = EntityType.m_20613_((EntityType)cat.m_6095_());
            catTag.m_128359_("id", key.toString());
            if (cat.m_8077_()) {
                catTag.m_128359_("DisplayName", cat.m_5446_().getString());
            }
            if (!catExists) {
                tagList.add((Object)catTag);
                player.m_5661_((Component)Component.m_237110_((String)"chat.book.save_cat_data", (Object[])new Object[]{cat.m_7755_()}), true);
            } else {
                tagList.m_7615_(catInList, (Tag)catTag);
                player.m_5661_((Component)Component.m_237110_((String)"chat.book.update_cat_data", (Object[])new Object[]{cat.m_7755_()}), true);
            }
            stack.m_41751_(compound);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        CompoundTag bookTag = player.m_21120_(hand).m_41783_();
        if (bookTag == null || bookTag.m_128456_()) {
            player.m_5661_((Component)Component.m_237115_((String)"chat.book.empty_book"), true);
        } else if (world.f_46443_) {
            this.openCatBook(bookTag, world);
        }
        return super.m_7203_(world, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openCatBook(CompoundTag bookTag, Level world) {
        Minecraft.m_91087_().m_91152_((Screen)new CatBookScreen(bookTag, world));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.cat_book.usage"));
    }
}

